/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelModifier;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class NoiseModifier
implements PixelModifier {
    protected final float intensity;

    public NoiseModifier(float intensity) {
        Preconditions.checkArgument((intensity >= 0.0f && intensity <= 1.0f ? 1 : 0) != 0, (Object)"intensity should be in 0-1 range.");
        this.intensity = intensity;
    }

    @Override
    public String getIdentifier() {
        return "noise-" + this.intensity;
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = class_5253.class_5254.method_27762((int)colorARGB);
        int red = class_5253.class_5254.method_27765((int)colorARGB);
        int green = class_5253.class_5254.method_27766((int)colorARGB);
        int blue = class_5253.class_5254.method_27767((int)colorARGB);
        red = this.addNoise(red);
        green = this.addNoise(green);
        blue = this.addNoise(blue);
        return class_5253.class_5254.method_27764((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected int addNoise(int colorValue) {
        float effect = this.intensity * (1.0f - (float)colorValue / 255.0f);
        effect = class_3532.method_16439((float)0.4f, (float)effect, (float)this.intensity);
        int noise = (int)((ThreadLocalRandom.current().nextDouble() * 2.0 - 1.0) * 255.0 * (double)effect);
        return class_3532.method_15340((int)(colorValue + noise), (int)0, (int)255);
    }
}

